/*
    TestsigningOff: Turn off testsigning
    Copyright (C) 2010  Jeffrey Bush <jeff@coderforlife.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/gpl.html>.
*/

#include "stdafx.h"

#include "BcdConstants.h"
#include "BcdObject.h"
#include "BcdStore.h"
#include "BcdElement.h"

using namespace ROOT::WMI;
using namespace BcdConstants;

using namespace System;
using namespace System::Management;

array<String^> ^GetIds(BcdObject ^o, unsigned int t) {
	ManagementBaseObject ^mbo;
	return o->GetElement(t, mbo) ? (array<String^>^)mbo->GetPropertyValue(L"Ids") : nullptr;
}

String ^GetString(BcdObject ^o, unsigned int t) {
	ManagementBaseObject ^mbo;
	return o->GetElement(t, mbo) ? (String^)mbo->GetPropertyValue(L"String") : nullptr;
}

bool GetBoolean(BcdObject ^o, unsigned int t, bool def) {
	ManagementBaseObject ^mbo;
	return o->GetElement(t, mbo) ? (bool)((Boolean^)mbo->GetPropertyValue(L"Boolean")) : def;
}

void SetBoolean(BcdObject ^o, unsigned int t, bool x) {
	if (!o->SetBooleanElement(x, t))
		throw gcnew InvalidOperationException();
}

int main(array<String^> ^args) {
	Console::WriteLine(L"TestsigningOff Copyright (C) 2010  Jeffrey Bush <jeff@coderforlife.com>");
	Console::WriteLine(L"This program comes with ABSOLUTELY NO WARRANTY;");
	Console::WriteLine(L"This is free software, and you are welcome to redistribute it");
	Console::WriteLine(L"under certain conditions;");
	Console::WriteLine(L"See http://www.gnu.org/licenses/gpl.html for more details.");
	Console::WriteLine();

	ConnectionOptions ^opts = gcnew ConnectionOptions();
	opts->Impersonation = ImpersonationLevel::Impersonate;
	opts->EnablePrivileges = true;

	ManagementScope ^scope = gcnew ManagementScope(L"root\\WMI", opts);

	// Open the system store
	BcdObject ^store = gcnew BcdObject(scope, Guids::SystemStore, L"");

	// Get the Bootmgr information
	String ^bm_name = GetString(store, BcdLibraryString_Description);
	bool bm_ts = GetBoolean(store, BcdLibraryBoolean_AllowPrereleaseSignatures, false);

	// Get the default GUID
	String ^def = nullptr;
	try {
		def = GetString(store, BcdBootMgrObject_DefaultObject);
	} catch (Exception^) {}

	// Get the current GUID
	BcdObject ^current = gcnew BcdObject(scope, Guids::Current, L"");
	String ^cur = current->Id;

	// Loop over all OS GUIDs
	Console::WriteLine(L"Loop");
	array<String^> ^guids = GetIds(store, BcdBootMgrObjectList_DisplayOrder);
	array<BcdObject^> ^objs = gcnew array<BcdObject^>(guids->Length);
	array<String^> ^names = gcnew array<String^>(guids->Length);
	array<bool> ^testsignings = gcnew array<bool>(guids->Length);
	bool any_ts = bm_ts;
	int def_i = -1, cur_i = -1;
	for (int i = 0; i < guids->Length; i++) {
		objs[i] = gcnew BcdObject(scope, guids[i], L"");
		names[i] = GetString(objs[i], BcdLibraryString_Description);
		testsignings[i] = GetBoolean(objs[i], BcdLibraryBoolean_AllowPrereleaseSignatures, false);
		any_ts |= testsignings[i];
		if (guids[i]->Equals(def)) def_i = i;
		if (guids[i]->Equals(cur)) cur_i = i;
	}

	// Final message
	if (any_ts) {
		String ^msg = L"You have TESTSIGNING 'on' for the following:\n";
		if (bm_ts)
			msg += L"  {bootmgr} "+bm_name+L"\n";
		if (cur_i >= 0 && testsignings[cur_i])
			msg += L"  {current} "+names[cur_i]+L"\n";
		if (def_i >= 0 && cur_i != def_i && testsignings[def_i])
			msg += L"  {default} "+names[def_i]+L"\n";
		for (int i = 0; i < guids->Length; i++) {
			if (i != cur_i && i != def_i && testsignings[i])
				msg += L"  "+guids[i]+L" "+names[i]+L"\n";
		}
		msg += L"Would you like to turn off TESTSIGNING for these? [Y/n] ";
		Console::WriteLine(msg);

		// y/n input
		String ^line;
		while ((line = Console::ReadLine()) != nullptr) {
			line = line->Trim();
			if (line->Length == 0 || line[0] == 'Y' || line[0] == 'y')
				break;
			else if (line[0] == 'n' || line[0] == 'N') {
				Console::WriteLine(L"Nothing was done.");
				return 0;
			}
		}

		// Set the data
		if (bm_ts)	SetBoolean(store, BcdLibraryBoolean_AllowPrereleaseSignatures, false);
		for (int i = 0; i < guids->Length; i++)
			if (testsignings[i])
				SetBoolean(objs[i], BcdLibraryBoolean_AllowPrereleaseSignatures, false);
		Console::WriteLine(L"Turned TESTSIGNING off.");
	} else {
		Console::WriteLine(L"Nothing has TESTSIGNING 'on'.");
	}

	return 0;
}
