﻿#pragma once
#include "stdafx.h"

// Created with mgmtclassgen BcdStore /N root\WMI /L MC

namespace ROOT {
    namespace WMI {
    using namespace System;
    using namespace System::ComponentModel;
    using namespace System::Management;
    using namespace System::Collections;
    using namespace System::Globalization;
    using namespace System;
    ref class BcdStore;
    
    
    // Functions ShouldSerialize<PropertyName> are functions used by VS property browser to check if a particular property has to be serialized. These functions are added for all ValueType properties ( properties of type Int32, BOOL etc.. which cannot be set to null). These functions use Is<PropertyName>Null function. These functions are also used in the TypeConverter implementation for the properties to check for NULL value of property so that an empty value can be shown in Property browser in case of Drag and Drop in Visual studio.
    // Functions Is<PropertyName>Null() are used to check if a property is NULL.
    // Functions Reset<PropertyName> are added for Nullable Read/Write properties. These functions are used by VS designer in property browser to set a property to NULL.
    // Every property added to the class for WMI property has attributes set to define its behavior in Visual Studio designer and also to define a TypeConverter to be used.
    // An Early Bound class generated for the WMI class.BcdStore
    public ref class BcdStore : public System::ComponentModel::Component {
        public : ref class BcdStoreCollection;
        public : ref class WMIValueTypeConverter;
        public : ref class ManagementSystemProperties;
        
        // Private property to hold the WMI namespace in which the class resides.
        private: static System::String^  CreatedWmiNamespace = L"root\\WMI";
        
        // Private property to hold the name of WMI class which created this class.
        private: static System::String^  CreatedClassName = L"BcdStore";
        
        // Private member variable to hold the ManagementScope which is used by the various methods.
        private: static System::Management::ManagementScope^  statMgmtScope = nullptr;
        
        private: ROOT::WMI::BcdStore::ManagementSystemProperties^  PrivateSystemProperties;
        
        // Underlying lateBound WMI object.
        private: System::Management::ManagementObject^  PrivateLateBoundObject;
        
        // Member variable to store the 'automatic commit' behavior for the class.
        private: System::Boolean AutoCommitProp;
        
        // Private variable to hold the embedded property representing the instance.
        private: System::Management::ManagementBaseObject^  embeddedObj;
        
        // The current WMI object used
        private: System::Management::ManagementBaseObject^  curObj;
        
        // Flag to indicate if the instance is an embedded object.
        private: System::Boolean isEmbedded;
        
        // Below are different overloads of constructors to initialize an instance of the class with a WMI object.
        public: BcdStore();
        public: BcdStore(System::String^  keyFilePath);
        public: BcdStore(System::Management::ManagementScope^  mgmtScope, System::String^  keyFilePath);
        public: BcdStore(System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions);
        public: BcdStore(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path);
        public: BcdStore(System::Management::ManagementPath^  path);
        public: BcdStore(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions);
        public: BcdStore(System::Management::ManagementObject^  theObject);
        public: BcdStore(System::Management::ManagementBaseObject^  theObject);
        // Property returns the namespace of the WMI class.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::String^  OriginatingNamespace {
            System::String^  get();
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::String^  ManagementClassName {
            System::String^  get();
        }
        
        // Property pointing to an embedded object to get System properties of the WMI object.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property ROOT::WMI::BcdStore::ManagementSystemProperties^  SystemProperties {
            ROOT::WMI::BcdStore::ManagementSystemProperties^  get();
        }
        
        // Property returning the underlying lateBound object.
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Management::ManagementBaseObject^  LateBoundObject {
            System::Management::ManagementBaseObject^  get();
        }
        
        // ManagementScope of the object.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Management::ManagementScope^  Scope {
            System::Management::ManagementScope^  get();
            System::Void set(System::Management::ManagementScope^  value);
        }
        
        // Property to show the commit behavior for the WMI object. If true, WMI object will be automatically saved after each property modification.(ie. Put() is called after modification of a property).
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Boolean AutoCommit {
            System::Boolean get();
            System::Void set(System::Boolean value);
        }
        
        // The ManagementPath of the underlying WMI object.
        public: [Browsable(true)]
        property System::Management::ManagementPath^  Path {
            System::Management::ManagementPath^  get();
            System::Void set(System::Management::ManagementPath^  value);
        }
        
        // Public static scope property which is used by the various methods.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        static property System::Management::ManagementScope^  StaticScope {
            System::Management::ManagementScope^  get();
            System::Void set(System::Management::ManagementScope^  value);
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden), 
        Description(L"A BcdStore is uniquely identified by its file path. The system store is denoted via an empty file path.")]
        property System::String^  FilePath {
            System::String^  get();
        }
        
        private: System::Boolean CheckIfProperClass(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                    System::Management::ObjectGetOptions^  OptionsParam);
        
        private: System::Boolean CheckIfProperClass(System::Management::ManagementBaseObject^  theObj);
        
        public: [Browsable(true)]
        System::Void CommitObject();
        
        public: [Browsable(true)]
        System::Void CommitObject(System::Management::PutOptions^  putOptions);
        
        private: System::Void Initialize();
        
        private: static System::String^  ConstructPath(System::String^  keyFilePath);
        
        private: System::Void InitializeObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                    System::Management::ObjectGetOptions^  getOptions);
        
        // Different overloads of GetInstances() help in enumerating instances of the WMI class.
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances();
        
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances(System::String^  condition);
        
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances(cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances(System::String^  condition, cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::Management::EnumerationOptions^  enumOptions);
        
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::String^  condition);
        
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdStore::BcdStoreCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::String^  condition, cli::array< System::String ^  >^  selectedProperties);
        
        public: [Browsable(true)]
        static ROOT::WMI::BcdStore^  CreateInstance();
        
        public: [Browsable(true)]
        System::Void Delete();
        
        public: System::Boolean CopyObject(System::UInt32 Flags, System::String^  SourceId, System::String^  SourceStoreFile, 
                    System::Management::ManagementBaseObject^  %Object);
        
        public: System::Boolean CopyObjects(System::UInt32 Flags, System::String^  SourceStoreFile, System::UInt32 Type);
        
        public: System::Boolean CreateObject(System::String^  Id, System::UInt32 Type, System::Management::ManagementBaseObject^  %Object);
        
        public: static System::Boolean CreateStore(System::String^  File, System::Management::ManagementBaseObject^  %Store);
        
        public: System::Boolean DeleteObject(System::String^  Id);
        
        public: static System::Boolean DeleteSystemStore();
        
        public: System::Boolean EnumerateObjects(System::UInt32 Type, cli::array< System::Management::ManagementBaseObject^  >^  %Objects);
        
        public: static System::Boolean ExportStore(System::String^  File);
        
        public: static System::Boolean GetSystemDisk(System::String^  %Disk);
        
        public: static System::Boolean GetSystemPartition(System::String^  %Partition);
        
        public: static System::Boolean ImportStore(System::String^  File);
        
        public: static System::Boolean ImportStoreWithFlags(System::String^  File, System::UInt32 Flags);
        
        public: System::Boolean OpenObject(System::String^  Id, System::Management::ManagementBaseObject^  %Object);
        
        public: static System::Boolean OpenStore(System::String^  File, System::Management::ManagementBaseObject^  %Store);
        
        public: static System::Boolean SetSystemStoreDevice(System::String^  Partition);
        
        public : // Enumerator implementation for enumerating instances of the class.
        ref class BcdStoreCollection : public System::Object, public System::Collections::ICollection {
            public : ref class BcdStoreEnumerator;
            
            private: ManagementObjectCollection^  privColObj;
            
            public: BcdStoreCollection(ManagementObjectCollection^  objCollection);
            public: virtual property System::Int32 Count {
                System::Int32 get();
            }
            
            public: virtual property System::Boolean IsSynchronized {
                System::Boolean get();
            }
            
            public: virtual property System::Object^  SyncRoot {
                System::Object^  get();
            }
            
            public: virtual System::Void CopyTo(System::Array^  array, System::Int32 index);
            
            public: virtual System::Collections::IEnumerator^  GetEnumerator();
            
            public : ref class BcdStoreEnumerator : public System::Object, public System::Collections::IEnumerator {
                
                private: ManagementObjectCollection::ManagementObjectEnumerator^  privObjEnum;
                
                public: BcdStoreEnumerator(ManagementObjectCollection::ManagementObjectEnumerator^  objEnum);
                public: virtual property System::Object^  Current {
                    System::Object^  get();
                }
                
                public: virtual System::Boolean MoveNext();
                
                public: virtual System::Void Reset();
            };
        };
        
        public : // TypeConverter to handle null values for ValueType properties
        ref class WMIValueTypeConverter : public System::ComponentModel::TypeConverter {
            
            private: System::ComponentModel::TypeConverter^  baseConverter;
            
            private: System::Type^  baseType;
            
            public: WMIValueTypeConverter(System::Type^  inBaseType);
            public: virtual System::Boolean CanConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, System::Type^  srcType) override;
            
            public: virtual System::Boolean CanConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, System::Type^  destinationType) override;
            
            public: virtual System::Object^  ConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, System::Globalization::CultureInfo^  culture, 
                        System::Object^  __identifier(value)) override;
            
            public: virtual System::Object^  CreateInstance(System::ComponentModel::ITypeDescriptorContext^  context, System::Collections::IDictionary^  dictionary) override;
            
            public: virtual System::Boolean GetCreateInstanceSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::ComponentModel::PropertyDescriptorCollection^  GetProperties(System::ComponentModel::ITypeDescriptorContext^  context, 
                        System::Object^  __identifier(value), cli::array< System::Attribute^  >^  attributeVar) override;
            
            public: virtual System::Boolean GetPropertiesSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::ComponentModel::TypeConverter::StandardValuesCollection^  GetStandardValues(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Boolean GetStandardValuesExclusive(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Boolean GetStandardValuesSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Object^  ConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, System::Globalization::CultureInfo^  culture, 
                        System::Object^  __identifier(value), System::Type^  destinationType) override;
        };
        
        public : // Embedded class to represent WMI system Properties.
        [TypeConverter(System::ComponentModel::ExpandableObjectConverter::typeid)]
        ref class ManagementSystemProperties {
            
            private: System::Management::ManagementBaseObject^  PrivateLateBoundObject;
            
            public: ManagementSystemProperties(System::Management::ManagementBaseObject^  ManagedObject);
            public: [Browsable(true)]
            property System::Int32 GENUS {
                System::Int32 get();
            }
            
            public: [Browsable(true)]
            property System::String^  CLASS {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  SUPERCLASS {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  DYNASTY {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  RELPATH {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::Int32 PROPERTY_COUNT {
                System::Int32 get();
            }
            
            public: [Browsable(true)]
            property cli::array< System::String^  >^  DERIVATION {
                cli::array< System::String^  >^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  SERVER {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  NAMESPACE {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  PATH {
                System::String^  get();
            }
        };
    };
    }
}
namespace ROOT {
    namespace WMI {
    
    
    inline BcdStore::BcdStore() {
        this->InitializeObject(nullptr, nullptr, nullptr);
    }
    
    inline BcdStore::BcdStore(System::String^  keyFilePath) {
        this->InitializeObject(nullptr, (gcnew System::Management::ManagementPath(ROOT::WMI::BcdStore::ConstructPath(keyFilePath))), 
            nullptr);
    }
    
    inline BcdStore::BcdStore(System::Management::ManagementScope^  mgmtScope, System::String^  keyFilePath) {
        this->InitializeObject((cli::safe_cast<System::Management::ManagementScope^  >(mgmtScope)), (gcnew System::Management::ManagementPath(ROOT::WMI::BcdStore::ConstructPath(keyFilePath))), 
            nullptr);
    }
    
    inline BcdStore::BcdStore(System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions) {
        this->InitializeObject(nullptr, path, getOptions);
    }
    
    inline BcdStore::BcdStore(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path) {
        this->InitializeObject(mgmtScope, path, nullptr);
    }
    
    inline BcdStore::BcdStore(System::Management::ManagementPath^  path) {
        this->InitializeObject(nullptr, path, nullptr);
    }
    
    inline BcdStore::BcdStore(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  getOptions) {
        this->InitializeObject(mgmtScope, path, getOptions);
    }
    
    inline BcdStore::BcdStore(System::Management::ManagementObject^  theObject) {
        Initialize();
        if (CheckIfProperClass(theObject) == true) {
            PrivateLateBoundObject = theObject;
            PrivateSystemProperties = (gcnew ROOT::WMI::BcdStore::ManagementSystemProperties(PrivateLateBoundObject));
            curObj = PrivateLateBoundObject;
        }
        else {
            throw (gcnew System::ArgumentException(L"Class name does not match."));
        }
    }
    
    inline BcdStore::BcdStore(System::Management::ManagementBaseObject^  theObject) {
        Initialize();
        if (CheckIfProperClass(theObject) == true) {
            embeddedObj = theObject;
            PrivateSystemProperties = (gcnew ROOT::WMI::BcdStore::ManagementSystemProperties(theObject));
            curObj = embeddedObj;
            isEmbedded = true;
        }
        else {
            throw (gcnew System::ArgumentException(L"Class name does not match."));
        }
    }
    
    inline System::String^  BcdStore::OriginatingNamespace::get() {
        return L"root\\WMI";
    }
    
    inline System::String^  BcdStore::ManagementClassName::get() {
        System::String^  strRet = CreatedClassName;
        if (curObj != nullptr) {
            if (curObj->ClassPath != nullptr) {
                strRet = (cli::safe_cast<System::String^  >(curObj[L"__CLASS"]));
                if ((strRet == nullptr) 
                            || (strRet == System::String::Empty)) {
                    strRet = CreatedClassName;
                }
            }
        }
        return strRet;
    }
    
    inline ROOT::WMI::BcdStore::ManagementSystemProperties^  BcdStore::SystemProperties::get() {
        return PrivateSystemProperties;
    }
    
    inline System::Management::ManagementBaseObject^  BcdStore::LateBoundObject::get() {
        return curObj;
    }
    
    inline System::Management::ManagementScope^  BcdStore::Scope::get() {
        if (isEmbedded == false) {
            return PrivateLateBoundObject->Scope;
        }
        else {
            return nullptr;
        }
    }
    inline System::Void BcdStore::Scope::set(System::Management::ManagementScope^  value) {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Scope = value;
        }
    }
    
    inline System::Boolean BcdStore::AutoCommit::get() {
        return AutoCommitProp;
    }
    inline System::Void BcdStore::AutoCommit::set(System::Boolean value) {
        AutoCommitProp = value;
    }
    
    inline System::Management::ManagementPath^  BcdStore::Path::get() {
        if (isEmbedded == false) {
            return PrivateLateBoundObject->Path;
        }
        else {
            return nullptr;
        }
    }
    inline System::Void BcdStore::Path::set(System::Management::ManagementPath^  value) {
        if (isEmbedded == false) {
            if (CheckIfProperClass(nullptr, __identifier(value), nullptr) != true) {
                throw (gcnew System::ArgumentException(L"Class name does not match."));
            }
            PrivateLateBoundObject->Path = value;
        }
    }
    
    inline System::Management::ManagementScope^  BcdStore::StaticScope::get() {
        return statMgmtScope;
    }
    inline System::Void BcdStore::StaticScope::set(System::Management::ManagementScope^  value) {
        statMgmtScope = value;
    }
    
    inline System::String^  BcdStore::FilePath::get() {
        return (cli::safe_cast<System::String^  >(curObj[L"FilePath"]));
    }
    
    inline System::Boolean BcdStore::CheckIfProperClass(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  OptionsParam) {
        if ((path != nullptr) 
                    && (System::String::Compare(path->ClassName, this->ManagementClassName, true, System::Globalization::CultureInfo::InvariantCulture) == 0)) {
            return true;
        }
        else {
            return CheckIfProperClass((gcnew System::Management::ManagementObject(mgmtScope, path, OptionsParam)));
        }
    }
    
    inline System::Boolean BcdStore::CheckIfProperClass(System::Management::ManagementBaseObject^  theObj) {
        if ((theObj != nullptr) 
                    && (System::String::Compare((cli::safe_cast<System::String^  >(theObj[L"__CLASS"])), this->ManagementClassName, 
                        true, System::Globalization::CultureInfo::InvariantCulture) == 0)) {
            return true;
        }
        else {
            System::Array^  parentClasses = (cli::safe_cast<System::Array^  >(theObj[L"__DERIVATION"]));
            if (parentClasses != nullptr) {
                System::Int32 count = 0;
                for (                count = 0; (count < parentClasses->Length);                 count = (count + 1)) {
                    if (System::String::Compare((cli::safe_cast<System::String^  >(parentClasses->GetValue(count))), this->ManagementClassName, 
                        true, System::Globalization::CultureInfo::InvariantCulture) == 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
    
    inline System::Void BcdStore::CommitObject() {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Void BcdStore::CommitObject(System::Management::PutOptions^  putOptions) {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Put(putOptions);
        }
    }
    
    inline System::Void BcdStore::Initialize() {
        AutoCommitProp = true;
        isEmbedded = false;
    }
    
    inline System::String^  BcdStore::ConstructPath(System::String^  keyFilePath) {
        System::String^  strPath = L"root\\WMI:BcdStore";
        strPath = System::String::Concat(strPath, System::String::Concat(L".FilePath=", System::String::Concat(L"\"", System::String::Concat(keyFilePath, 
                        L"\""))));
        return strPath;
    }
    
    inline System::Void BcdStore::InitializeObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  getOptions) {
        Initialize();
        if (path != nullptr) {
            if (CheckIfProperClass(mgmtScope, path, getOptions) != true) {
                throw (gcnew System::ArgumentException(L"Class name does not match."));
            }
        }
        PrivateLateBoundObject = (gcnew System::Management::ManagementObject(mgmtScope, path, getOptions));
        PrivateSystemProperties = (gcnew ROOT::WMI::BcdStore::ManagementSystemProperties(PrivateLateBoundObject));
        curObj = PrivateLateBoundObject;
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances() {
        return GetInstances(nullptr, nullptr, nullptr);
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances(System::String^  condition) {
        return GetInstances(nullptr, condition, nullptr);
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances(cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(nullptr, nullptr, selectedProperties);
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances(System::String^  condition, cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(nullptr, condition, selectedProperties);
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::Management::EnumerationOptions^  enumOptions) {
        if (mgmtScope == nullptr) {
            if (statMgmtScope == nullptr) {
                mgmtScope = (gcnew System::Management::ManagementScope());
                mgmtScope->Path->NamespacePath = L"root\\WMI";
            }
            else {
                mgmtScope = statMgmtScope;
            }
        }
        System::Management::ManagementPath^  pathObj = (gcnew System::Management::ManagementPath());
        pathObj->ClassName = L"BcdStore";
        pathObj->NamespacePath = L"root\\WMI";
        System::Management::ManagementClass^  clsObject = (gcnew System::Management::ManagementClass(mgmtScope, pathObj, nullptr));
        if (enumOptions == nullptr) {
            enumOptions = (gcnew System::Management::EnumerationOptions());
            enumOptions->EnsureLocatable = true;
        }
        return (gcnew ROOT::WMI::BcdStore::BcdStoreCollection(clsObject->GetInstances(enumOptions)));
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::String^  condition) {
        return GetInstances(mgmtScope, condition, nullptr);
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(mgmtScope, nullptr, selectedProperties);
    }
    
    inline ROOT::WMI::BcdStore::BcdStoreCollection^  BcdStore::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::String^  condition, cli::array< System::String ^  >^  selectedProperties) {
        if (mgmtScope == nullptr) {
            if (statMgmtScope == nullptr) {
                mgmtScope = (gcnew System::Management::ManagementScope());
                mgmtScope->Path->NamespacePath = L"root\\WMI";
            }
            else {
                mgmtScope = statMgmtScope;
            }
        }
        System::Management::ManagementObjectSearcher^  ObjectSearcher = (gcnew System::Management::ManagementObjectSearcher(mgmtScope, 
            (gcnew SelectQuery(L"BcdStore", condition, selectedProperties))));
        System::Management::EnumerationOptions^  enumOptions = (gcnew System::Management::EnumerationOptions());
        enumOptions->EnsureLocatable = true;
        ObjectSearcher->Options = enumOptions;
        return (gcnew ROOT::WMI::BcdStore::BcdStoreCollection(ObjectSearcher->Get()));
    }
    
    inline ROOT::WMI::BcdStore^  BcdStore::CreateInstance() {
        System::Management::ManagementScope^  mgmtScope = nullptr;
        if (statMgmtScope == nullptr) {
            mgmtScope = (gcnew System::Management::ManagementScope());
            mgmtScope->Path->NamespacePath = CreatedWmiNamespace;
        }
        else {
            mgmtScope = statMgmtScope;
        }
        System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
        System::Management::ManagementClass^  tmpMgmtClass = (gcnew System::Management::ManagementClass(mgmtScope, mgmtPath, nullptr));
        return (gcnew ROOT::WMI::BcdStore(tmpMgmtClass->CreateInstance()));
    }
    
    inline System::Void BcdStore::Delete() {
        PrivateLateBoundObject->Delete();
    }
    
    inline System::Boolean BcdStore::CopyObject(System::UInt32 Flags, System::String^  SourceId, System::String^  SourceStoreFile, 
                System::Management::ManagementBaseObject^  %Object) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"CopyObject");
            inParams[L"Flags"] = (cli::safe_cast<System::UInt32 ^  >(Flags));
            inParams[L"SourceId"] = (cli::safe_cast<System::String ^  >(SourceId));
            inParams[L"SourceStoreFile"] = (cli::safe_cast<System::String ^  >(SourceStoreFile));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"CopyObject", inParams, 
                nullptr);
            Object = (cli::safe_cast<System::Management::ManagementBaseObject^  >(outParams->Properties[L"Object"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Object = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::CopyObjects(System::UInt32 Flags, System::String^  SourceStoreFile, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"CopyObjects");
            inParams[L"Flags"] = (cli::safe_cast<System::UInt32 ^  >(Flags));
            inParams[L"SourceStoreFile"] = (cli::safe_cast<System::String ^  >(SourceStoreFile));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"CopyObjects", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::CreateObject(System::String^  Id, System::UInt32 Type, System::Management::ManagementBaseObject^  %Object) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"CreateObject");
            inParams[L"Id"] = (cli::safe_cast<System::String ^  >(Id));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"CreateObject", inParams, 
                nullptr);
            Object = (cli::safe_cast<System::Management::ManagementBaseObject^  >(outParams->Properties[L"Object"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Object = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::CreateStore(System::String^  File, System::Management::ManagementBaseObject^  %Store) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            inParams = classObj->GetMethodParameters(L"CreateStore");
            inParams[L"File"] = (cli::safe_cast<System::String ^  >(File));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"CreateStore", inParams, nullptr);
            Store = (cli::safe_cast<System::Management::ManagementBaseObject^  >(outParams->Properties[L"Store"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Store = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::DeleteObject(System::String^  Id) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"DeleteObject");
            inParams[L"Id"] = (cli::safe_cast<System::String ^  >(Id));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"DeleteObject", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::DeleteSystemStore() {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"DeleteSystemStore", inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::EnumerateObjects(System::UInt32 Type, cli::array< System::Management::ManagementBaseObject^  >^  %Objects) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"EnumerateObjects");
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"EnumerateObjects", inParams, 
                nullptr);
            Objects = (cli::safe_cast<cli::array< System::Management::ManagementBaseObject^  >^  >(outParams->Properties[L"Objects"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Objects = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::ExportStore(System::String^  File) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            inParams = classObj->GetMethodParameters(L"ExportStore");
            inParams[L"File"] = (cli::safe_cast<System::String ^  >(File));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"ExportStore", inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::GetSystemDisk(System::String^  %Disk) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"GetSystemDisk", inParams, nullptr);
            Disk = System::Convert::ToString(outParams->Properties[L"Disk"]->Value);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Disk = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::GetSystemPartition(System::String^  %Partition) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"GetSystemPartition", inParams, nullptr);
            Partition = System::Convert::ToString(outParams->Properties[L"Partition"]->Value);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Partition = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::ImportStore(System::String^  File) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            inParams = classObj->GetMethodParameters(L"ImportStore");
            inParams[L"File"] = (cli::safe_cast<System::String ^  >(File));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"ImportStore", inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::ImportStoreWithFlags(System::String^  File, System::UInt32 Flags) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            inParams = classObj->GetMethodParameters(L"ImportStoreWithFlags");
            inParams[L"File"] = (cli::safe_cast<System::String ^  >(File));
            inParams[L"Flags"] = (cli::safe_cast<System::UInt32 ^  >(Flags));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"ImportStoreWithFlags", inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::OpenObject(System::String^  Id, System::Management::ManagementBaseObject^  %Object) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"OpenObject");
            inParams[L"Id"] = (cli::safe_cast<System::String ^  >(Id));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"OpenObject", inParams, 
                nullptr);
            Object = (cli::safe_cast<System::Management::ManagementBaseObject^  >(outParams->Properties[L"Object"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Object = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::OpenStore(System::String^  File, System::Management::ManagementBaseObject^  %Store) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            inParams = classObj->GetMethodParameters(L"OpenStore");
            inParams[L"File"] = (cli::safe_cast<System::String ^  >(File));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"OpenStore", inParams, nullptr);
            Store = (cli::safe_cast<System::Management::ManagementBaseObject^  >(outParams->Properties[L"Store"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Store = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdStore::SetSystemStoreDevice(System::String^  Partition) {
        System::Boolean IsMethodStatic = true;
        if (IsMethodStatic == true) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
            System::Management::ManagementClass^  classObj = (gcnew System::Management::ManagementClass(statMgmtScope, mgmtPath, 
                nullptr));
            inParams = classObj->GetMethodParameters(L"SetSystemStoreDevice");
            inParams[L"Partition"] = (cli::safe_cast<System::String ^  >(Partition));
            System::Management::ManagementBaseObject^  outParams = classObj->InvokeMethod(L"SetSystemStoreDevice", inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    
    inline BcdStore::BcdStoreCollection::BcdStoreCollection(ManagementObjectCollection^  objCollection) {
        privColObj = objCollection;
    }
    
    inline System::Int32 BcdStore::BcdStoreCollection::Count::get() {
        return privColObj->Count;
    }
    
    inline System::Boolean BcdStore::BcdStoreCollection::IsSynchronized::get() {
        return privColObj->IsSynchronized;
    }
    
    inline System::Object^  BcdStore::BcdStoreCollection::SyncRoot::get() {
        return this;
    }
    
    inline System::Void BcdStore::BcdStoreCollection::CopyTo(System::Array^  array, System::Int32 index) {
        privColObj->CopyTo(array, index);
        System::Int32 nCtr;
        for (        nCtr = 0; (nCtr < array->Length);         nCtr = (nCtr + 1)) {
            array->SetValue((gcnew ROOT::WMI::BcdStore((cli::safe_cast<System::Management::ManagementObject^  >(array->GetValue(nCtr))))), 
                nCtr);
        }
    }
    
    inline System::Collections::IEnumerator^  BcdStore::BcdStoreCollection::GetEnumerator() {
        return (gcnew ROOT::WMI::BcdStore::BcdStoreCollection::BcdStoreEnumerator(privColObj->GetEnumerator()));
    }
    
    
    inline BcdStore::BcdStoreCollection::BcdStoreEnumerator::BcdStoreEnumerator(ManagementObjectCollection::ManagementObjectEnumerator^  objEnum) {
        privObjEnum = objEnum;
    }
    
    inline System::Object^  BcdStore::BcdStoreCollection::BcdStoreEnumerator::Current::get() {
        return (gcnew ROOT::WMI::BcdStore((cli::safe_cast<System::Management::ManagementObject^  >(privObjEnum->Current))));
    }
    
    inline System::Boolean BcdStore::BcdStoreCollection::BcdStoreEnumerator::MoveNext() {
        return privObjEnum->MoveNext();
    }
    
    inline System::Void BcdStore::BcdStoreCollection::BcdStoreEnumerator::Reset() {
        privObjEnum->Reset();
    }
    
    
    inline BcdStore::WMIValueTypeConverter::WMIValueTypeConverter(System::Type^  inBaseType) {
        baseConverter = System::ComponentModel::TypeDescriptor::GetConverter(inBaseType);
        baseType = inBaseType;
    }
    
    inline System::Boolean BcdStore::WMIValueTypeConverter::CanConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Type^  srcType) {
        return baseConverter->CanConvertFrom(context, srcType);
    }
    
    inline System::Boolean BcdStore::WMIValueTypeConverter::CanConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Type^  destinationType) {
        return baseConverter->CanConvertTo(context, destinationType);
    }
    
    inline System::Object^  BcdStore::WMIValueTypeConverter::ConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Globalization::CultureInfo^  culture, System::Object^  __identifier(value)) {
        return baseConverter->ConvertFrom(context, culture, __identifier(value));
    }
    
    inline System::Object^  BcdStore::WMIValueTypeConverter::CreateInstance(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Collections::IDictionary^  dictionary) {
        return baseConverter->CreateInstance(context, dictionary);
    }
    
    inline System::Boolean BcdStore::WMIValueTypeConverter::GetCreateInstanceSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetCreateInstanceSupported(context);
    }
    
    inline System::ComponentModel::PropertyDescriptorCollection^  BcdStore::WMIValueTypeConverter::GetProperties(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Object^  __identifier(value), cli::array< System::Attribute^  >^  attributeVar) {
        return baseConverter->GetProperties(context, __identifier(value), attributeVar);
    }
    
    inline System::Boolean BcdStore::WMIValueTypeConverter::GetPropertiesSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetPropertiesSupported(context);
    }
    
    inline System::ComponentModel::TypeConverter::StandardValuesCollection^  BcdStore::WMIValueTypeConverter::GetStandardValues(
                System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValues(context);
    }
    
    inline System::Boolean BcdStore::WMIValueTypeConverter::GetStandardValuesExclusive(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValuesExclusive(context);
    }
    
    inline System::Boolean BcdStore::WMIValueTypeConverter::GetStandardValuesSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValuesSupported(context);
    }
    
    inline System::Object^  BcdStore::WMIValueTypeConverter::ConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Globalization::CultureInfo^  culture, System::Object^  __identifier(value), System::Type^  destinationType) {
        if (baseType->BaseType == System::Enum::typeid) {
            if (__identifier(value)->GetType() == destinationType) {
                return __identifier(value);
            }
            if (((__identifier(value) == nullptr) 
                        && (context != nullptr)) 
                        && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
                return  "NULL_ENUM_VALUE" ;
            }
            return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
        }
        if ((baseType == System::Boolean::typeid) 
                    && (baseType->BaseType == System::ValueType::typeid)) {
            if (((__identifier(value) == nullptr) 
                        && (context != nullptr)) 
                        && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
                return L"";
            }
            return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
        }
        if ((context != nullptr) 
                    && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
            return L"";
        }
        return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
    }
    
    
    inline BcdStore::ManagementSystemProperties::ManagementSystemProperties(System::Management::ManagementBaseObject^  ManagedObject) {
        PrivateLateBoundObject = ManagedObject;
    }
    
    inline System::Int32 BcdStore::ManagementSystemProperties::GENUS::get() {
        return (cli::safe_cast<System::Int32 >(PrivateLateBoundObject[L"__GENUS"]));
    }
    
    inline System::String^  BcdStore::ManagementSystemProperties::CLASS::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__CLASS"]));
    }
    
    inline System::String^  BcdStore::ManagementSystemProperties::SUPERCLASS::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__SUPERCLASS"]));
    }
    
    inline System::String^  BcdStore::ManagementSystemProperties::DYNASTY::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__DYNASTY"]));
    }
    
    inline System::String^  BcdStore::ManagementSystemProperties::RELPATH::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__RELPATH"]));
    }
    
    inline System::Int32 BcdStore::ManagementSystemProperties::PROPERTY_COUNT::get() {
        return (cli::safe_cast<System::Int32 >(PrivateLateBoundObject[L"__PROPERTY_COUNT"]));
    }
    
    inline cli::array< System::String^  >^  BcdStore::ManagementSystemProperties::DERIVATION::get() {
        return (cli::safe_cast<cli::array< System::String^  >^  >(PrivateLateBoundObject[L"__DERIVATION"]));
    }
    
    inline System::String^  BcdStore::ManagementSystemProperties::SERVER::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__SERVER"]));
    }
    
    inline System::String^  BcdStore::ManagementSystemProperties::NAMESPACE::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__NAMESPACE"]));
    }
    
    inline System::String^  BcdStore::ManagementSystemProperties::PATH::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__PATH"]));
    }
    }
}
