﻿#pragma once
#include "stdafx.h"

// Created with mgmtclassgen BcdObject /N root\WMI /L MC

namespace ROOT {
    namespace WMI {
    using namespace System;
    using namespace System::ComponentModel;
    using namespace System::Management;
    using namespace System::Collections;
    using namespace System::Globalization;
    using namespace System;
    ref class BcdObject;
    
    
    // Functions ShouldSerialize<PropertyName> are functions used by VS property browser to check if a particular property has to be serialized. These functions are added for all ValueType properties ( properties of type Int32, BOOL etc.. which cannot be set to null). These functions use Is<PropertyName>Null function. These functions are also used in the TypeConverter implementation for the properties to check for NULL value of property so that an empty value can be shown in Property browser in case of Drag and Drop in Visual studio.
    // Functions Is<PropertyName>Null() are used to check if a property is NULL.
    // Functions Reset<PropertyName> are added for Nullable Read/Write properties. These functions are used by VS designer in property browser to set a property to NULL.
    // Every property added to the class for WMI property has attributes set to define its behavior in Visual Studio designer and also to define a TypeConverter to be used.
    // An Early Bound class generated for the WMI class.BcdObject
    public ref class BcdObject : public System::ComponentModel::Component {
        public : ref class BcdObjectCollection;
        public : ref class WMIValueTypeConverter;
        public : ref class ManagementSystemProperties;
        
        // Private property to hold the WMI namespace in which the class resides.
        private: static System::String^  CreatedWmiNamespace = L"root\\WMI";
        
        // Private property to hold the name of WMI class which created this class.
        private: static System::String^  CreatedClassName = L"BcdObject";
        
        // Private member variable to hold the ManagementScope which is used by the various methods.
        private: static System::Management::ManagementScope^  statMgmtScope = nullptr;
        
        private: ROOT::WMI::BcdObject::ManagementSystemProperties^  PrivateSystemProperties;
        
        // Underlying lateBound WMI object.
        private: System::Management::ManagementObject^  PrivateLateBoundObject;
        
        // Member variable to store the 'automatic commit' behavior for the class.
        private: System::Boolean AutoCommitProp;
        
        // Private variable to hold the embedded property representing the instance.
        private: System::Management::ManagementBaseObject^  embeddedObj;
        
        // The current WMI object used
        private: System::Management::ManagementBaseObject^  curObj;
        
        // Flag to indicate if the instance is an embedded object.
        private: System::Boolean isEmbedded;
        
        // Below are different overloads of constructors to initialize an instance of the class with a WMI object.
        public: BcdObject();
        public: BcdObject(System::String^  keyId, System::String^  keyStoreFilePath);
        public: BcdObject(System::Management::ManagementScope^  mgmtScope, System::String^  keyId, System::String^  keyStoreFilePath);
        public: BcdObject(System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions);
        public: BcdObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path);
        public: BcdObject(System::Management::ManagementPath^  path);
        public: BcdObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions);
        public: BcdObject(System::Management::ManagementObject^  theObject);
        public: BcdObject(System::Management::ManagementBaseObject^  theObject);
        // Property returns the namespace of the WMI class.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::String^  OriginatingNamespace {
            System::String^  get();
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::String^  ManagementClassName {
            System::String^  get();
        }
        
        // Property pointing to an embedded object to get System properties of the WMI object.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property ROOT::WMI::BcdObject::ManagementSystemProperties^  SystemProperties {
            ROOT::WMI::BcdObject::ManagementSystemProperties^  get();
        }
        
        // Property returning the underlying lateBound object.
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Management::ManagementBaseObject^  LateBoundObject {
            System::Management::ManagementBaseObject^  get();
        }
        
        // ManagementScope of the object.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Management::ManagementScope^  Scope {
            System::Management::ManagementScope^  get();
            System::Void set(System::Management::ManagementScope^  value);
        }
        
        // Property to show the commit behavior for the WMI object. If true, WMI object will be automatically saved after each property modification.(ie. Put() is called after modification of a property).
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Boolean AutoCommit {
            System::Boolean get();
            System::Void set(System::Boolean value);
        }
        
        // The ManagementPath of the underlying WMI object.
        public: [Browsable(true)]
        property System::Management::ManagementPath^  Path {
            System::Management::ManagementPath^  get();
            System::Void set(System::Management::ManagementPath^  value);
        }
        
        // Public static scope property which is used by the various methods.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        static property System::Management::ManagementScope^  StaticScope {
            System::Management::ManagementScope^  get();
            System::Void set(System::Management::ManagementScope^  value);
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden), 
        Description(L"This is the guid id of this object, unique to this store.")]
        property System::String^  Id {
            System::String^  get();
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden), 
        Description(L"This is the file path of the store that this object belongs to.")]
        property System::String^  StoreFilePath {
            System::String^  get();
        }
        
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Boolean IsTypeNull {
            System::Boolean get();
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden), 
        Description(L"The upper 4 bits (28-31) represent the object type. The meaning of the lower 28 b" 
L"its (0-27) is dependent on the object type."), 
        TypeConverter(ROOT::WMI::BcdObject::WMIValueTypeConverter::typeid)]
        property System::UInt32 Type {
            System::UInt32 get();
        }
        
        private: System::Boolean CheckIfProperClass(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                    System::Management::ObjectGetOptions^  OptionsParam);
        
        private: System::Boolean CheckIfProperClass(System::Management::ManagementBaseObject^  theObj);
        
        private: System::Boolean ShouldSerializeType();
        
        public: [Browsable(true)]
        System::Void CommitObject();
        
        public: [Browsable(true)]
        System::Void CommitObject(System::Management::PutOptions^  putOptions);
        
        private: System::Void Initialize();
        
        private: static System::String^  ConstructPath(System::String^  keyId, System::String^  keyStoreFilePath);
        
        private: System::Void InitializeObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                    System::Management::ObjectGetOptions^  getOptions);
        
        // Different overloads of GetInstances() help in enumerating instances of the WMI class.
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances();
        
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances(System::String^  condition);
        
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances(cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances(System::String^  condition, cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::Management::EnumerationOptions^  enumOptions);
        
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::String^  condition);
        
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdObject::BcdObjectCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::String^  condition, cli::array< System::String ^  >^  selectedProperties);
        
        public: [Browsable(true)]
        static ROOT::WMI::BcdObject^  CreateInstance();
        
        public: [Browsable(true)]
        System::Void Delete();
        
        public: System::Boolean DeleteElement(System::UInt32 Type);
        
        public: System::Boolean EnumerateElements(cli::array< System::Management::ManagementBaseObject^  >^  %Elements);
        
        public: System::Boolean EnumerateElementTypes(cli::array< System::UInt32 >^  %Types);
        
        public: System::Boolean GetElement(System::UInt32 Type, System::Management::ManagementBaseObject^  %Element);
        
        public: System::Boolean SetBooleanElement(System::Boolean Boolean, System::UInt32 Type);
        
        public: System::Boolean SetDeviceElement(System::String^  AdditionalOptions, System::UInt32 DeviceType, System::UInt32 Type);
        
        public: System::Boolean SetFileDeviceElement(
                    System::String^  AdditionalOptions, 
                    System::UInt32 DeviceType, 
                    System::String^  ParentAdditionalOptions, 
                    System::UInt32 ParentDeviceType, 
                    System::String^  ParentPath, 
                    System::String^  Path, 
                    System::UInt32 Type);
        
        public: System::Boolean SetIntegerElement(System::UInt64 Integer, System::UInt32 Type);
        
        public: System::Boolean SetIntegerListElement(cli::array< System::UInt64 >^  Integers, System::UInt32 Type);
        
        public: System::Boolean SetObjectElement(System::String^  Id, System::UInt32 Type);
        
        public: System::Boolean SetObjectListElement(cli::array< System::String^  >^  Ids, System::UInt32 Type);
        
        public: System::Boolean SetPartitionDeviceElement(System::String^  AdditionalOptions, System::UInt32 DeviceType, 
                    System::String^  Path, System::UInt32 Type);
        
        public: System::Boolean SetStringElement(System::String^  String, System::UInt32 Type);
        
        public : // Enumerator implementation for enumerating instances of the class.
        ref class BcdObjectCollection : public System::Object, public System::Collections::ICollection {
            public : ref class BcdObjectEnumerator;
            
            private: ManagementObjectCollection^  privColObj;
            
            public: BcdObjectCollection(ManagementObjectCollection^  objCollection);
            public: virtual property System::Int32 Count {
                System::Int32 get();
            }
            
            public: virtual property System::Boolean IsSynchronized {
                System::Boolean get();
            }
            
            public: virtual property System::Object^  SyncRoot {
                System::Object^  get();
            }
            
            public: virtual System::Void CopyTo(System::Array^  array, System::Int32 index);
            
            public: virtual System::Collections::IEnumerator^  GetEnumerator();
            
            public : ref class BcdObjectEnumerator : public System::Object, public System::Collections::IEnumerator {
                
                private: ManagementObjectCollection::ManagementObjectEnumerator^  privObjEnum;
                
                public: BcdObjectEnumerator(ManagementObjectCollection::ManagementObjectEnumerator^  objEnum);
                public: virtual property System::Object^  Current {
                    System::Object^  get();
                }
                
                public: virtual System::Boolean MoveNext();
                
                public: virtual System::Void Reset();
            };
        };
        
        public : // TypeConverter to handle null values for ValueType properties
        ref class WMIValueTypeConverter : public System::ComponentModel::TypeConverter {
            
            private: System::ComponentModel::TypeConverter^  baseConverter;
            
            private: System::Type^  baseType;
            
            public: WMIValueTypeConverter(System::Type^  inBaseType);
            public: virtual System::Boolean CanConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, System::Type^  srcType) override;
            
            public: virtual System::Boolean CanConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, System::Type^  destinationType) override;
            
            public: virtual System::Object^  ConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, System::Globalization::CultureInfo^  culture, 
                        System::Object^  __identifier(value)) override;
            
            public: virtual System::Object^  CreateInstance(System::ComponentModel::ITypeDescriptorContext^  context, System::Collections::IDictionary^  dictionary) override;
            
            public: virtual System::Boolean GetCreateInstanceSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::ComponentModel::PropertyDescriptorCollection^  GetProperties(System::ComponentModel::ITypeDescriptorContext^  context, 
                        System::Object^  __identifier(value), cli::array< System::Attribute^  >^  attributeVar) override;
            
            public: virtual System::Boolean GetPropertiesSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::ComponentModel::TypeConverter::StandardValuesCollection^  GetStandardValues(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Boolean GetStandardValuesExclusive(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Boolean GetStandardValuesSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Object^  ConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, System::Globalization::CultureInfo^  culture, 
                        System::Object^  __identifier(value), System::Type^  destinationType) override;
        };
        
        public : // Embedded class to represent WMI system Properties.
        [TypeConverter(System::ComponentModel::ExpandableObjectConverter::typeid)]
        ref class ManagementSystemProperties {
            
            private: System::Management::ManagementBaseObject^  PrivateLateBoundObject;
            
            public: ManagementSystemProperties(System::Management::ManagementBaseObject^  ManagedObject);
            public: [Browsable(true)]
            property System::Int32 GENUS {
                System::Int32 get();
            }
            
            public: [Browsable(true)]
            property System::String^  CLASS {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  SUPERCLASS {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  DYNASTY {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  RELPATH {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::Int32 PROPERTY_COUNT {
                System::Int32 get();
            }
            
            public: [Browsable(true)]
            property cli::array< System::String^  >^  DERIVATION {
                cli::array< System::String^  >^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  SERVER {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  NAMESPACE {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  PATH {
                System::String^  get();
            }
        };
    };
    }
}
namespace ROOT {
    namespace WMI {
    
    
    inline BcdObject::BcdObject() {
        this->InitializeObject(nullptr, nullptr, nullptr);
    }
    
    inline BcdObject::BcdObject(System::String^  keyId, System::String^  keyStoreFilePath) {
        this->InitializeObject(nullptr, (gcnew System::Management::ManagementPath(ROOT::WMI::BcdObject::ConstructPath(keyId, 
                    keyStoreFilePath))), nullptr);
    }
    
    inline BcdObject::BcdObject(System::Management::ManagementScope^  mgmtScope, System::String^  keyId, System::String^  keyStoreFilePath) {
        this->InitializeObject((cli::safe_cast<System::Management::ManagementScope^  >(mgmtScope)), (gcnew System::Management::ManagementPath(ROOT::WMI::BcdObject::ConstructPath(keyId, 
                    keyStoreFilePath))), nullptr);
    }
    
    inline BcdObject::BcdObject(System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions) {
        this->InitializeObject(nullptr, path, getOptions);
    }
    
    inline BcdObject::BcdObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path) {
        this->InitializeObject(mgmtScope, path, nullptr);
    }
    
    inline BcdObject::BcdObject(System::Management::ManagementPath^  path) {
        this->InitializeObject(nullptr, path, nullptr);
    }
    
    inline BcdObject::BcdObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  getOptions) {
        this->InitializeObject(mgmtScope, path, getOptions);
    }
    
    inline BcdObject::BcdObject(System::Management::ManagementObject^  theObject) {
        Initialize();
        if (CheckIfProperClass(theObject) == true) {
            PrivateLateBoundObject = theObject;
            PrivateSystemProperties = (gcnew ROOT::WMI::BcdObject::ManagementSystemProperties(PrivateLateBoundObject));
            curObj = PrivateLateBoundObject;
        }
        else {
            throw (gcnew System::ArgumentException(L"Class name does not match."));
        }
    }
    
    inline BcdObject::BcdObject(System::Management::ManagementBaseObject^  theObject) {
        Initialize();
        if (CheckIfProperClass(theObject) == true) {
            embeddedObj = theObject;
            PrivateSystemProperties = (gcnew ROOT::WMI::BcdObject::ManagementSystemProperties(theObject));
            curObj = embeddedObj;
            isEmbedded = true;
        }
        else {
            throw (gcnew System::ArgumentException(L"Class name does not match."));
        }
    }
    
    inline System::String^  BcdObject::OriginatingNamespace::get() {
        return L"root\\WMI";
    }
    
    inline System::String^  BcdObject::ManagementClassName::get() {
        System::String^  strRet = CreatedClassName;
        if (curObj != nullptr) {
            if (curObj->ClassPath != nullptr) {
                strRet = (cli::safe_cast<System::String^  >(curObj[L"__CLASS"]));
                if ((strRet == nullptr) 
                            || (strRet == System::String::Empty)) {
                    strRet = CreatedClassName;
                }
            }
        }
        return strRet;
    }
    
    inline ROOT::WMI::BcdObject::ManagementSystemProperties^  BcdObject::SystemProperties::get() {
        return PrivateSystemProperties;
    }
    
    inline System::Management::ManagementBaseObject^  BcdObject::LateBoundObject::get() {
        return curObj;
    }
    
    inline System::Management::ManagementScope^  BcdObject::Scope::get() {
        if (isEmbedded == false) {
            return PrivateLateBoundObject->Scope;
        }
        else {
            return nullptr;
        }
    }
    inline System::Void BcdObject::Scope::set(System::Management::ManagementScope^  value) {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Scope = value;
        }
    }
    
    inline System::Boolean BcdObject::AutoCommit::get() {
        return AutoCommitProp;
    }
    inline System::Void BcdObject::AutoCommit::set(System::Boolean value) {
        AutoCommitProp = value;
    }
    
    inline System::Management::ManagementPath^  BcdObject::Path::get() {
        if (isEmbedded == false) {
            return PrivateLateBoundObject->Path;
        }
        else {
            return nullptr;
        }
    }
    inline System::Void BcdObject::Path::set(System::Management::ManagementPath^  value) {
        if (isEmbedded == false) {
            if (CheckIfProperClass(nullptr, __identifier(value), nullptr) != true) {
                throw (gcnew System::ArgumentException(L"Class name does not match."));
            }
            PrivateLateBoundObject->Path = value;
        }
    }
    
    inline System::Management::ManagementScope^  BcdObject::StaticScope::get() {
        return statMgmtScope;
    }
    inline System::Void BcdObject::StaticScope::set(System::Management::ManagementScope^  value) {
        statMgmtScope = value;
    }
    
    inline System::String^  BcdObject::Id::get() {
        return (cli::safe_cast<System::String^  >(curObj[L"Id"]));
    }
    
    inline System::String^  BcdObject::StoreFilePath::get() {
        return (cli::safe_cast<System::String^  >(curObj[L"StoreFilePath"]));
    }
    
    inline System::Boolean BcdObject::IsTypeNull::get() {
        if (curObj[L"Type"] == nullptr) {
            return true;
        }
        else {
            return false;
        }
    }
    
    inline System::UInt32 BcdObject::Type::get() {
        if (curObj[L"Type"] == nullptr) {
            return System::Convert::ToUInt32(0);
        }
        return (cli::safe_cast<System::UInt32 >(curObj[L"Type"]));
    }
    
    inline System::Boolean BcdObject::CheckIfProperClass(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  OptionsParam) {
        if ((path != nullptr) 
                    && (System::String::Compare(path->ClassName, this->ManagementClassName, true, System::Globalization::CultureInfo::InvariantCulture) == 0)) {
            return true;
        }
        else {
            return CheckIfProperClass((gcnew System::Management::ManagementObject(mgmtScope, path, OptionsParam)));
        }
    }
    
    inline System::Boolean BcdObject::CheckIfProperClass(System::Management::ManagementBaseObject^  theObj) {
        if ((theObj != nullptr) 
                    && (System::String::Compare((cli::safe_cast<System::String^  >(theObj[L"__CLASS"])), this->ManagementClassName, 
                        true, System::Globalization::CultureInfo::InvariantCulture) == 0)) {
            return true;
        }
        else {
            System::Array^  parentClasses = (cli::safe_cast<System::Array^  >(theObj[L"__DERIVATION"]));
            if (parentClasses != nullptr) {
                System::Int32 count = 0;
                for (                count = 0; (count < parentClasses->Length);                 count = (count + 1)) {
                    if (System::String::Compare((cli::safe_cast<System::String^  >(parentClasses->GetValue(count))), this->ManagementClassName, 
                        true, System::Globalization::CultureInfo::InvariantCulture) == 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
    
    inline System::Boolean BcdObject::ShouldSerializeType() {
        if (this->IsTypeNull == false) {
            return true;
        }
        return false;
    }
    
    inline System::Void BcdObject::CommitObject() {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Void BcdObject::CommitObject(System::Management::PutOptions^  putOptions) {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Put(putOptions);
        }
    }
    
    inline System::Void BcdObject::Initialize() {
        AutoCommitProp = true;
        isEmbedded = false;
    }
    
    inline System::String^  BcdObject::ConstructPath(System::String^  keyId, System::String^  keyStoreFilePath) {
        System::String^  strPath = L"root\\WMI:BcdObject";
        strPath = System::String::Concat(strPath, System::String::Concat(L".Id=", System::String::Concat(L"\"", System::String::Concat(keyId, 
                        L"\""))));
        strPath = System::String::Concat(strPath, System::String::Concat(L",StoreFilePath=", System::String::Concat(L"\"", 
                    System::String::Concat(keyStoreFilePath, L"\""))));
        return strPath;
    }
    
    inline System::Void BcdObject::InitializeObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  getOptions) {
        Initialize();
        if (path != nullptr) {
            if (CheckIfProperClass(mgmtScope, path, getOptions) != true) {
                throw (gcnew System::ArgumentException(L"Class name does not match."));
            }
        }
        PrivateLateBoundObject = (gcnew System::Management::ManagementObject(mgmtScope, path, getOptions));
        PrivateSystemProperties = (gcnew ROOT::WMI::BcdObject::ManagementSystemProperties(PrivateLateBoundObject));
        curObj = PrivateLateBoundObject;
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances() {
        return GetInstances(nullptr, nullptr, nullptr);
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances(System::String^  condition) {
        return GetInstances(nullptr, condition, nullptr);
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances(cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(nullptr, nullptr, selectedProperties);
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances(System::String^  condition, cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(nullptr, condition, selectedProperties);
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::Management::EnumerationOptions^  enumOptions) {
        if (mgmtScope == nullptr) {
            if (statMgmtScope == nullptr) {
                mgmtScope = (gcnew System::Management::ManagementScope());
                mgmtScope->Path->NamespacePath = L"root\\WMI";
            }
            else {
                mgmtScope = statMgmtScope;
            }
        }
        System::Management::ManagementPath^  pathObj = (gcnew System::Management::ManagementPath());
        pathObj->ClassName = L"BcdObject";
        pathObj->NamespacePath = L"root\\WMI";
        System::Management::ManagementClass^  clsObject = (gcnew System::Management::ManagementClass(mgmtScope, pathObj, nullptr));
        if (enumOptions == nullptr) {
            enumOptions = (gcnew System::Management::EnumerationOptions());
            enumOptions->EnsureLocatable = true;
        }
        return (gcnew ROOT::WMI::BcdObject::BcdObjectCollection(clsObject->GetInstances(enumOptions)));
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::String^  condition) {
        return GetInstances(mgmtScope, condition, nullptr);
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(mgmtScope, nullptr, selectedProperties);
    }
    
    inline ROOT::WMI::BcdObject::BcdObjectCollection^  BcdObject::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::String^  condition, cli::array< System::String ^  >^  selectedProperties) {
        if (mgmtScope == nullptr) {
            if (statMgmtScope == nullptr) {
                mgmtScope = (gcnew System::Management::ManagementScope());
                mgmtScope->Path->NamespacePath = L"root\\WMI";
            }
            else {
                mgmtScope = statMgmtScope;
            }
        }
        System::Management::ManagementObjectSearcher^  ObjectSearcher = (gcnew System::Management::ManagementObjectSearcher(mgmtScope, 
            (gcnew SelectQuery(L"BcdObject", condition, selectedProperties))));
        System::Management::EnumerationOptions^  enumOptions = (gcnew System::Management::EnumerationOptions());
        enumOptions->EnsureLocatable = true;
        ObjectSearcher->Options = enumOptions;
        return (gcnew ROOT::WMI::BcdObject::BcdObjectCollection(ObjectSearcher->Get()));
    }
    
    inline ROOT::WMI::BcdObject^  BcdObject::CreateInstance() {
        System::Management::ManagementScope^  mgmtScope = nullptr;
        if (statMgmtScope == nullptr) {
            mgmtScope = (gcnew System::Management::ManagementScope());
            mgmtScope->Path->NamespacePath = CreatedWmiNamespace;
        }
        else {
            mgmtScope = statMgmtScope;
        }
        System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
        System::Management::ManagementClass^  tmpMgmtClass = (gcnew System::Management::ManagementClass(mgmtScope, mgmtPath, nullptr));
        return (gcnew ROOT::WMI::BcdObject(tmpMgmtClass->CreateInstance()));
    }
    
    inline System::Void BcdObject::Delete() {
        PrivateLateBoundObject->Delete();
    }
    
    inline System::Boolean BcdObject::DeleteElement(System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"DeleteElement");
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"DeleteElement", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::EnumerateElements(cli::array< System::Management::ManagementBaseObject^  >^  %Elements) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"EnumerateElements", inParams, 
                nullptr);
            Elements = (cli::safe_cast<cli::array< System::Management::ManagementBaseObject^  >^  >(outParams->Properties[L"Elements"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Elements = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::EnumerateElementTypes(cli::array< System::UInt32 >^  %Types) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"EnumerateElementTypes", 
                inParams, nullptr);
            Types = (cli::safe_cast<cli::array< System::UInt32 >^  >(outParams->Properties[L"Types"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Types = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::GetElement(System::UInt32 Type, System::Management::ManagementBaseObject^  %Element) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"GetElement");
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"GetElement", inParams, 
                nullptr);
            Element = (cli::safe_cast<System::Management::ManagementBaseObject^  >(outParams->Properties[L"Element"]->Value));
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            Element = nullptr;
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetBooleanElement(System::Boolean Boolean, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetBooleanElement");
            inParams[L"Boolean"] = (cli::safe_cast<System::Boolean ^  >(Boolean));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetBooleanElement", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetDeviceElement(System::String^  AdditionalOptions, System::UInt32 DeviceType, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetDeviceElement");
            inParams[L"AdditionalOptions"] = (cli::safe_cast<System::String ^  >(AdditionalOptions));
            inParams[L"DeviceType"] = (cli::safe_cast<System::UInt32 ^  >(DeviceType));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetDeviceElement", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetFileDeviceElement(
                System::String^  AdditionalOptions, 
                System::UInt32 DeviceType, 
                System::String^  ParentAdditionalOptions, 
                System::UInt32 ParentDeviceType, 
                System::String^  ParentPath, 
                System::String^  Path, 
                System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetFileDeviceElement");
            inParams[L"AdditionalOptions"] = (cli::safe_cast<System::String ^  >(AdditionalOptions));
            inParams[L"DeviceType"] = (cli::safe_cast<System::UInt32 ^  >(DeviceType));
            inParams[L"ParentAdditionalOptions"] = (cli::safe_cast<System::String ^  >(ParentAdditionalOptions));
            inParams[L"ParentDeviceType"] = (cli::safe_cast<System::UInt32 ^  >(ParentDeviceType));
            inParams[L"ParentPath"] = (cli::safe_cast<System::String ^  >(ParentPath));
            inParams[L"Path"] = (cli::safe_cast<System::String ^  >(Path));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetFileDeviceElement", 
                inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetIntegerElement(System::UInt64 Integer, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetIntegerElement");
            inParams[L"Integer"] = (cli::safe_cast<System::UInt64 ^  >(Integer));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetIntegerElement", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetIntegerListElement(cli::array< System::UInt64 >^  Integers, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetIntegerListElement");
            inParams[L"Integers"] = (cli::safe_cast<cli::array< System::UInt64 >^  >(Integers));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetIntegerListElement", 
                inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetObjectElement(System::String^  Id, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetObjectElement");
            inParams[L"Id"] = (cli::safe_cast<System::String ^  >(Id));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetObjectElement", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetObjectListElement(cli::array< System::String^  >^  Ids, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetObjectListElement");
            inParams[L"Ids"] = (cli::safe_cast<cli::array< System::String^  >^  >(Ids));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetObjectListElement", 
                inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetPartitionDeviceElement(System::String^  AdditionalOptions, System::UInt32 DeviceType, 
                System::String^  Path, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetPartitionDeviceElement");
            inParams[L"AdditionalOptions"] = (cli::safe_cast<System::String ^  >(AdditionalOptions));
            inParams[L"DeviceType"] = (cli::safe_cast<System::UInt32 ^  >(DeviceType));
            inParams[L"Path"] = (cli::safe_cast<System::String ^  >(Path));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetPartitionDeviceElement", 
                inParams, nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    inline System::Boolean BcdObject::SetStringElement(System::String^  String, System::UInt32 Type) {
        if (isEmbedded == false) {
            System::Management::ManagementBaseObject^  inParams = nullptr;
            inParams = PrivateLateBoundObject->GetMethodParameters(L"SetStringElement");
            inParams[L"String"] = (cli::safe_cast<System::String ^  >(String));
            inParams[L"Type"] = (cli::safe_cast<System::UInt32 ^  >(Type));
            System::Management::ManagementBaseObject^  outParams = PrivateLateBoundObject->InvokeMethod(L"SetStringElement", inParams, 
                nullptr);
            return System::Convert::ToBoolean(outParams->Properties[L"ReturnValue"]->Value);
        }
        else {
            return System::Convert::ToBoolean(0);
        }
    }
    
    
    inline BcdObject::BcdObjectCollection::BcdObjectCollection(ManagementObjectCollection^  objCollection) {
        privColObj = objCollection;
    }
    
    inline System::Int32 BcdObject::BcdObjectCollection::Count::get() {
        return privColObj->Count;
    }
    
    inline System::Boolean BcdObject::BcdObjectCollection::IsSynchronized::get() {
        return privColObj->IsSynchronized;
    }
    
    inline System::Object^  BcdObject::BcdObjectCollection::SyncRoot::get() {
        return this;
    }
    
    inline System::Void BcdObject::BcdObjectCollection::CopyTo(System::Array^  array, System::Int32 index) {
        privColObj->CopyTo(array, index);
        System::Int32 nCtr;
        for (        nCtr = 0; (nCtr < array->Length);         nCtr = (nCtr + 1)) {
            array->SetValue((gcnew ROOT::WMI::BcdObject((cli::safe_cast<System::Management::ManagementObject^  >(array->GetValue(nCtr))))), 
                nCtr);
        }
    }
    
    inline System::Collections::IEnumerator^  BcdObject::BcdObjectCollection::GetEnumerator() {
        return (gcnew ROOT::WMI::BcdObject::BcdObjectCollection::BcdObjectEnumerator(privColObj->GetEnumerator()));
    }
    
    
    inline BcdObject::BcdObjectCollection::BcdObjectEnumerator::BcdObjectEnumerator(ManagementObjectCollection::ManagementObjectEnumerator^  objEnum) {
        privObjEnum = objEnum;
    }
    
    inline System::Object^  BcdObject::BcdObjectCollection::BcdObjectEnumerator::Current::get() {
        return (gcnew ROOT::WMI::BcdObject((cli::safe_cast<System::Management::ManagementObject^  >(privObjEnum->Current))));
    }
    
    inline System::Boolean BcdObject::BcdObjectCollection::BcdObjectEnumerator::MoveNext() {
        return privObjEnum->MoveNext();
    }
    
    inline System::Void BcdObject::BcdObjectCollection::BcdObjectEnumerator::Reset() {
        privObjEnum->Reset();
    }
    
    
    inline BcdObject::WMIValueTypeConverter::WMIValueTypeConverter(System::Type^  inBaseType) {
        baseConverter = System::ComponentModel::TypeDescriptor::GetConverter(inBaseType);
        baseType = inBaseType;
    }
    
    inline System::Boolean BcdObject::WMIValueTypeConverter::CanConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Type^  srcType) {
        return baseConverter->CanConvertFrom(context, srcType);
    }
    
    inline System::Boolean BcdObject::WMIValueTypeConverter::CanConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Type^  destinationType) {
        return baseConverter->CanConvertTo(context, destinationType);
    }
    
    inline System::Object^  BcdObject::WMIValueTypeConverter::ConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Globalization::CultureInfo^  culture, System::Object^  __identifier(value)) {
        return baseConverter->ConvertFrom(context, culture, __identifier(value));
    }
    
    inline System::Object^  BcdObject::WMIValueTypeConverter::CreateInstance(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Collections::IDictionary^  dictionary) {
        return baseConverter->CreateInstance(context, dictionary);
    }
    
    inline System::Boolean BcdObject::WMIValueTypeConverter::GetCreateInstanceSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetCreateInstanceSupported(context);
    }
    
    inline System::ComponentModel::PropertyDescriptorCollection^  BcdObject::WMIValueTypeConverter::GetProperties(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Object^  __identifier(value), cli::array< System::Attribute^  >^  attributeVar) {
        return baseConverter->GetProperties(context, __identifier(value), attributeVar);
    }
    
    inline System::Boolean BcdObject::WMIValueTypeConverter::GetPropertiesSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetPropertiesSupported(context);
    }
    
    inline System::ComponentModel::TypeConverter::StandardValuesCollection^  BcdObject::WMIValueTypeConverter::GetStandardValues(
                System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValues(context);
    }
    
    inline System::Boolean BcdObject::WMIValueTypeConverter::GetStandardValuesExclusive(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValuesExclusive(context);
    }
    
    inline System::Boolean BcdObject::WMIValueTypeConverter::GetStandardValuesSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValuesSupported(context);
    }
    
    inline System::Object^  BcdObject::WMIValueTypeConverter::ConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Globalization::CultureInfo^  culture, System::Object^  __identifier(value), System::Type^  destinationType) {
        if (baseType->BaseType == System::Enum::typeid) {
            if (__identifier(value)->GetType() == destinationType) {
                return __identifier(value);
            }
            if (((__identifier(value) == nullptr) 
                        && (context != nullptr)) 
                        && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
                return  "NULL_ENUM_VALUE" ;
            }
            return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
        }
        if ((baseType == System::Boolean::typeid) 
                    && (baseType->BaseType == System::ValueType::typeid)) {
            if (((__identifier(value) == nullptr) 
                        && (context != nullptr)) 
                        && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
                return L"";
            }
            return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
        }
        if ((context != nullptr) 
                    && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
            return L"";
        }
        return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
    }
    
    
    inline BcdObject::ManagementSystemProperties::ManagementSystemProperties(System::Management::ManagementBaseObject^  ManagedObject) {
        PrivateLateBoundObject = ManagedObject;
    }
    
    inline System::Int32 BcdObject::ManagementSystemProperties::GENUS::get() {
        return (cli::safe_cast<System::Int32 >(PrivateLateBoundObject[L"__GENUS"]));
    }
    
    inline System::String^  BcdObject::ManagementSystemProperties::CLASS::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__CLASS"]));
    }
    
    inline System::String^  BcdObject::ManagementSystemProperties::SUPERCLASS::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__SUPERCLASS"]));
    }
    
    inline System::String^  BcdObject::ManagementSystemProperties::DYNASTY::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__DYNASTY"]));
    }
    
    inline System::String^  BcdObject::ManagementSystemProperties::RELPATH::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__RELPATH"]));
    }
    
    inline System::Int32 BcdObject::ManagementSystemProperties::PROPERTY_COUNT::get() {
        return (cli::safe_cast<System::Int32 >(PrivateLateBoundObject[L"__PROPERTY_COUNT"]));
    }
    
    inline cli::array< System::String^  >^  BcdObject::ManagementSystemProperties::DERIVATION::get() {
        return (cli::safe_cast<cli::array< System::String^  >^  >(PrivateLateBoundObject[L"__DERIVATION"]));
    }
    
    inline System::String^  BcdObject::ManagementSystemProperties::SERVER::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__SERVER"]));
    }
    
    inline System::String^  BcdObject::ManagementSystemProperties::NAMESPACE::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__NAMESPACE"]));
    }
    
    inline System::String^  BcdObject::ManagementSystemProperties::PATH::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__PATH"]));
    }
    }
}
