﻿#pragma once
#include "stdafx.h"

// Created with mgmtclassgen BcdElement /N root\WMI /L MC

namespace ROOT {
    namespace WMI {
    using namespace System;
    using namespace System::ComponentModel;
    using namespace System::Management;
    using namespace System::Collections;
    using namespace System::Globalization;
    using namespace System;
    ref class BcdElement;
    
    
    // Functions ShouldSerialize<PropertyName> are functions used by VS property browser to check if a particular property has to be serialized. These functions are added for all ValueType properties ( properties of type Int32, BOOL etc.. which cannot be set to null). These functions use Is<PropertyName>Null function. These functions are also used in the TypeConverter implementation for the properties to check for NULL value of property so that an empty value can be shown in Property browser in case of Drag and Drop in Visual studio.
    // Functions Is<PropertyName>Null() are used to check if a property is NULL.
    // Functions Reset<PropertyName> are added for Nullable Read/Write properties. These functions are used by VS designer in property browser to set a property to NULL.
    // Every property added to the class for WMI property has attributes set to define its behavior in Visual Studio designer and also to define a TypeConverter to be used.
    // An Early Bound class generated for the WMI class.BcdElement
    public ref class BcdElement : public System::ComponentModel::Component {
        public : ref class BcdElementCollection;
        public : ref class WMIValueTypeConverter;
        public : ref class ManagementSystemProperties;
        
        // Private property to hold the WMI namespace in which the class resides.
        private: static System::String^  CreatedWmiNamespace = L"root\\WMI";
        
        // Private property to hold the name of WMI class which created this class.
        private: static System::String^  CreatedClassName = L"BcdElement";
        
        // Private member variable to hold the ManagementScope which is used by the various methods.
        private: static System::Management::ManagementScope^  statMgmtScope = nullptr;
        
        private: ROOT::WMI::BcdElement::ManagementSystemProperties^  PrivateSystemProperties;
        
        // Underlying lateBound WMI object.
        private: System::Management::ManagementObject^  PrivateLateBoundObject;
        
        // Member variable to store the 'automatic commit' behavior for the class.
        private: System::Boolean AutoCommitProp;
        
        // Private variable to hold the embedded property representing the instance.
        private: System::Management::ManagementBaseObject^  embeddedObj;
        
        // The current WMI object used
        private: System::Management::ManagementBaseObject^  curObj;
        
        // Flag to indicate if the instance is an embedded object.
        private: System::Boolean isEmbedded;
        
        // Below are different overloads of constructors to initialize an instance of the class with a WMI object.
        public: BcdElement();
        public: BcdElement(System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions);
        public: BcdElement(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path);
        public: BcdElement(System::Management::ManagementPath^  path);
        public: BcdElement(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions);
        public: BcdElement(System::Management::ManagementObject^  theObject);
        public: BcdElement(System::Management::ManagementBaseObject^  theObject);
        // Property returns the namespace of the WMI class.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::String^  OriginatingNamespace {
            System::String^  get();
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::String^  ManagementClassName {
            System::String^  get();
        }
        
        // Property pointing to an embedded object to get System properties of the WMI object.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property ROOT::WMI::BcdElement::ManagementSystemProperties^  SystemProperties {
            ROOT::WMI::BcdElement::ManagementSystemProperties^  get();
        }
        
        // Property returning the underlying lateBound object.
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Management::ManagementBaseObject^  LateBoundObject {
            System::Management::ManagementBaseObject^  get();
        }
        
        // ManagementScope of the object.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Management::ManagementScope^  Scope {
            System::Management::ManagementScope^  get();
            System::Void set(System::Management::ManagementScope^  value);
        }
        
        // Property to show the commit behavior for the WMI object. If true, WMI object will be automatically saved after each property modification.(ie. Put() is called after modification of a property).
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Boolean AutoCommit {
            System::Boolean get();
            System::Void set(System::Boolean value);
        }
        
        // The ManagementPath of the underlying WMI object.
        public: [Browsable(true)]
        property System::Management::ManagementPath^  Path {
            System::Management::ManagementPath^  get();
            System::Void set(System::Management::ManagementPath^  value);
        }
        
        // Public static scope property which is used by the various methods.
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        static property System::Management::ManagementScope^  StaticScope {
            System::Management::ManagementScope^  get();
            System::Void set(System::Management::ManagementScope^  value);
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden), 
        Description(L"This is the id of the object that this element belongs to.")]
        property System::String^  ObjectId {
            System::String^  get();
            System::Void set(System::String^  value);
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden), 
        Description(L"This is the file path of the store that this element is a part of.")]
        property System::String^  StoreFilePath {
            System::String^  get();
            System::Void set(System::String^  value);
        }
        
        public: [Browsable(false), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden)]
        property System::Boolean IsTypeNull {
            System::Boolean get();
        }
        
        public: [Browsable(true), 
        DesignerSerializationVisibility(System::ComponentModel::DesignerSerializationVisibility::Hidden), 
        Description(L"The upper 4 bits (28-31) determine the class of the element. The next 4 bits (24-" 
L"27) determine the format of the element data. The lower 24 bits (0-23) determine" 
L" the sub-type of the element."), 
        TypeConverter(ROOT::WMI::BcdElement::WMIValueTypeConverter::typeid)]
        property System::UInt32 Type {
            System::UInt32 get();
            System::Void set(System::UInt32 value);
        }
        
        private: System::Boolean CheckIfProperClass(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                    System::Management::ObjectGetOptions^  OptionsParam);
        
        private: System::Boolean CheckIfProperClass(System::Management::ManagementBaseObject^  theObj);
        
        private: System::Void ResetObjectId();
        
        private: System::Void ResetStoreFilePath();
        
        private: System::Boolean ShouldSerializeType();
        
        private: System::Void ResetType();
        
        public: [Browsable(true)]
        System::Void CommitObject();
        
        public: [Browsable(true)]
        System::Void CommitObject(System::Management::PutOptions^  putOptions);
        
        private: System::Void Initialize();
        
        private: static System::String^  ConstructPath();
        
        private: System::Void InitializeObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                    System::Management::ObjectGetOptions^  getOptions);
        
        // Different overloads of GetInstances() help in enumerating instances of the WMI class.
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances();
        
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances(System::String^  condition);
        
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances(cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances(System::String^  condition, cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::Management::EnumerationOptions^  enumOptions);
        
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::String^  condition);
        
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    cli::array< System::String ^  >^  selectedProperties);
        
        public: static ROOT::WMI::BcdElement::BcdElementCollection^  GetInstances(System::Management::ManagementScope^  mgmtScope, 
                    System::String^  condition, cli::array< System::String ^  >^  selectedProperties);
        
        public: [Browsable(true)]
        static ROOT::WMI::BcdElement^  CreateInstance();
        
        public: [Browsable(true)]
        System::Void Delete();
        
        public : // Enumerator implementation for enumerating instances of the class.
        ref class BcdElementCollection : public System::Object, public System::Collections::ICollection {
            public : ref class BcdElementEnumerator;
            
            private: ManagementObjectCollection^  privColObj;
            
            public: BcdElementCollection(ManagementObjectCollection^  objCollection);
            public: virtual property System::Int32 Count {
                System::Int32 get();
            }
            
            public: virtual property System::Boolean IsSynchronized {
                System::Boolean get();
            }
            
            public: virtual property System::Object^  SyncRoot {
                System::Object^  get();
            }
            
            public: virtual System::Void CopyTo(System::Array^  array, System::Int32 index);
            
            public: virtual System::Collections::IEnumerator^  GetEnumerator();
            
            public : ref class BcdElementEnumerator : public System::Object, public System::Collections::IEnumerator {
                
                private: ManagementObjectCollection::ManagementObjectEnumerator^  privObjEnum;
                
                public: BcdElementEnumerator(ManagementObjectCollection::ManagementObjectEnumerator^  objEnum);
                public: virtual property System::Object^  Current {
                    System::Object^  get();
                }
                
                public: virtual System::Boolean MoveNext();
                
                public: virtual System::Void Reset();
            };
        };
        
        public : // TypeConverter to handle null values for ValueType properties
        ref class WMIValueTypeConverter : public System::ComponentModel::TypeConverter {
            
            private: System::ComponentModel::TypeConverter^  baseConverter;
            
            private: System::Type^  baseType;
            
            public: WMIValueTypeConverter(System::Type^  inBaseType);
            public: virtual System::Boolean CanConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, System::Type^  srcType) override;
            
            public: virtual System::Boolean CanConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, System::Type^  destinationType) override;
            
            public: virtual System::Object^  ConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, System::Globalization::CultureInfo^  culture, 
                        System::Object^  __identifier(value)) override;
            
            public: virtual System::Object^  CreateInstance(System::ComponentModel::ITypeDescriptorContext^  context, System::Collections::IDictionary^  dictionary) override;
            
            public: virtual System::Boolean GetCreateInstanceSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::ComponentModel::PropertyDescriptorCollection^  GetProperties(System::ComponentModel::ITypeDescriptorContext^  context, 
                        System::Object^  __identifier(value), cli::array< System::Attribute^  >^  attributeVar) override;
            
            public: virtual System::Boolean GetPropertiesSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::ComponentModel::TypeConverter::StandardValuesCollection^  GetStandardValues(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Boolean GetStandardValuesExclusive(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Boolean GetStandardValuesSupported(System::ComponentModel::ITypeDescriptorContext^  context) override;
            
            public: virtual System::Object^  ConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, System::Globalization::CultureInfo^  culture, 
                        System::Object^  __identifier(value), System::Type^  destinationType) override;
        };
        
        public : // Embedded class to represent WMI system Properties.
        [TypeConverter(System::ComponentModel::ExpandableObjectConverter::typeid)]
        ref class ManagementSystemProperties {
            
            private: System::Management::ManagementBaseObject^  PrivateLateBoundObject;
            
            public: ManagementSystemProperties(System::Management::ManagementBaseObject^  ManagedObject);
            public: [Browsable(true)]
            property System::Int32 GENUS {
                System::Int32 get();
            }
            
            public: [Browsable(true)]
            property System::String^  CLASS {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  SUPERCLASS {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  DYNASTY {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  RELPATH {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::Int32 PROPERTY_COUNT {
                System::Int32 get();
            }
            
            public: [Browsable(true)]
            property cli::array< System::String^  >^  DERIVATION {
                cli::array< System::String^  >^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  SERVER {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  NAMESPACE {
                System::String^  get();
            }
            
            public: [Browsable(true)]
            property System::String^  PATH {
                System::String^  get();
            }
        };
    };
    }
}
namespace ROOT {
    namespace WMI {
    
    
    inline BcdElement::BcdElement() {
        this->InitializeObject(nullptr, nullptr, nullptr);
    }
    
    inline BcdElement::BcdElement(System::Management::ManagementPath^  path, System::Management::ObjectGetOptions^  getOptions) {
        this->InitializeObject(nullptr, path, getOptions);
    }
    
    inline BcdElement::BcdElement(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path) {
        this->InitializeObject(mgmtScope, path, nullptr);
    }
    
    inline BcdElement::BcdElement(System::Management::ManagementPath^  path) {
        this->InitializeObject(nullptr, path, nullptr);
    }
    
    inline BcdElement::BcdElement(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  getOptions) {
        this->InitializeObject(mgmtScope, path, getOptions);
    }
    
    inline BcdElement::BcdElement(System::Management::ManagementObject^  theObject) {
        Initialize();
        if (CheckIfProperClass(theObject) == true) {
            PrivateLateBoundObject = theObject;
            PrivateSystemProperties = (gcnew ROOT::WMI::BcdElement::ManagementSystemProperties(PrivateLateBoundObject));
            curObj = PrivateLateBoundObject;
        }
        else {
            throw (gcnew System::ArgumentException(L"Class name does not match."));
        }
    }
    
    inline BcdElement::BcdElement(System::Management::ManagementBaseObject^  theObject) {
        Initialize();
        if (CheckIfProperClass(theObject) == true) {
            embeddedObj = theObject;
            PrivateSystemProperties = (gcnew ROOT::WMI::BcdElement::ManagementSystemProperties(theObject));
            curObj = embeddedObj;
            isEmbedded = true;
        }
        else {
            throw (gcnew System::ArgumentException(L"Class name does not match."));
        }
    }
    
    inline System::String^  BcdElement::OriginatingNamespace::get() {
        return L"root\\WMI";
    }
    
    inline System::String^  BcdElement::ManagementClassName::get() {
        System::String^  strRet = CreatedClassName;
        if (curObj != nullptr) {
            if (curObj->ClassPath != nullptr) {
                strRet = (cli::safe_cast<System::String^  >(curObj[L"__CLASS"]));
                if ((strRet == nullptr) 
                            || (strRet == System::String::Empty)) {
                    strRet = CreatedClassName;
                }
            }
        }
        return strRet;
    }
    
    inline ROOT::WMI::BcdElement::ManagementSystemProperties^  BcdElement::SystemProperties::get() {
        return PrivateSystemProperties;
    }
    
    inline System::Management::ManagementBaseObject^  BcdElement::LateBoundObject::get() {
        return curObj;
    }
    
    inline System::Management::ManagementScope^  BcdElement::Scope::get() {
        if (isEmbedded == false) {
            return PrivateLateBoundObject->Scope;
        }
        else {
            return nullptr;
        }
    }
    inline System::Void BcdElement::Scope::set(System::Management::ManagementScope^  value) {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Scope = value;
        }
    }
    
    inline System::Boolean BcdElement::AutoCommit::get() {
        return AutoCommitProp;
    }
    inline System::Void BcdElement::AutoCommit::set(System::Boolean value) {
        AutoCommitProp = value;
    }
    
    inline System::Management::ManagementPath^  BcdElement::Path::get() {
        if (isEmbedded == false) {
            return PrivateLateBoundObject->Path;
        }
        else {
            return nullptr;
        }
    }
    inline System::Void BcdElement::Path::set(System::Management::ManagementPath^  value) {
        if (isEmbedded == false) {
            if (CheckIfProperClass(nullptr, __identifier(value), nullptr) != true) {
                throw (gcnew System::ArgumentException(L"Class name does not match."));
            }
            PrivateLateBoundObject->Path = value;
        }
    }
    
    inline System::Management::ManagementScope^  BcdElement::StaticScope::get() {
        return statMgmtScope;
    }
    inline System::Void BcdElement::StaticScope::set(System::Management::ManagementScope^  value) {
        statMgmtScope = value;
    }
    
    inline System::String^  BcdElement::ObjectId::get() {
        return (cli::safe_cast<System::String^  >(curObj[L"ObjectId"]));
    }
    inline System::Void BcdElement::ObjectId::set(System::String^  value) {
        curObj[L"ObjectId"] = value;
        if ((isEmbedded == false) 
                    && (AutoCommitProp == true)) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::String^  BcdElement::StoreFilePath::get() {
        return (cli::safe_cast<System::String^  >(curObj[L"StoreFilePath"]));
    }
    inline System::Void BcdElement::StoreFilePath::set(System::String^  value) {
        curObj[L"StoreFilePath"] = value;
        if ((isEmbedded == false) 
                    && (AutoCommitProp == true)) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Boolean BcdElement::IsTypeNull::get() {
        if (curObj[L"Type"] == nullptr) {
            return true;
        }
        else {
            return false;
        }
    }
    
    inline System::UInt32 BcdElement::Type::get() {
        if (curObj[L"Type"] == nullptr) {
            return System::Convert::ToUInt32(0);
        }
        return (cli::safe_cast<System::UInt32 >(curObj[L"Type"]));
    }
    inline System::Void BcdElement::Type::set(System::UInt32 value) {
        curObj[L"Type"] = value;
        if ((isEmbedded == false) 
                    && (AutoCommitProp == true)) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Boolean BcdElement::CheckIfProperClass(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  OptionsParam) {
        if ((path != nullptr) 
                    && (System::String::Compare(path->ClassName, this->ManagementClassName, true, System::Globalization::CultureInfo::InvariantCulture) == 0)) {
            return true;
        }
        else {
            return CheckIfProperClass((gcnew System::Management::ManagementObject(mgmtScope, path, OptionsParam)));
        }
    }
    
    inline System::Boolean BcdElement::CheckIfProperClass(System::Management::ManagementBaseObject^  theObj) {
        if ((theObj != nullptr) 
                    && (System::String::Compare((cli::safe_cast<System::String^  >(theObj[L"__CLASS"])), this->ManagementClassName, 
                        true, System::Globalization::CultureInfo::InvariantCulture) == 0)) {
            return true;
        }
        else {
            System::Array^  parentClasses = (cli::safe_cast<System::Array^  >(theObj[L"__DERIVATION"]));
            if (parentClasses != nullptr) {
                System::Int32 count = 0;
                for (                count = 0; (count < parentClasses->Length);                 count = (count + 1)) {
                    if (System::String::Compare((cli::safe_cast<System::String^  >(parentClasses->GetValue(count))), this->ManagementClassName, 
                        true, System::Globalization::CultureInfo::InvariantCulture) == 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
    
    inline System::Void BcdElement::ResetObjectId() {
        curObj[L"ObjectId"] = nullptr;
        if ((isEmbedded == false) 
                    && (AutoCommitProp == true)) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Void BcdElement::ResetStoreFilePath() {
        curObj[L"StoreFilePath"] = nullptr;
        if ((isEmbedded == false) 
                    && (AutoCommitProp == true)) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Boolean BcdElement::ShouldSerializeType() {
        if (this->IsTypeNull == false) {
            return true;
        }
        return false;
    }
    
    inline System::Void BcdElement::ResetType() {
        curObj[L"Type"] = nullptr;
        if ((isEmbedded == false) 
                    && (AutoCommitProp == true)) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Void BcdElement::CommitObject() {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Put();
        }
    }
    
    inline System::Void BcdElement::CommitObject(System::Management::PutOptions^  putOptions) {
        if (isEmbedded == false) {
            PrivateLateBoundObject->Put(putOptions);
        }
    }
    
    inline System::Void BcdElement::Initialize() {
        AutoCommitProp = true;
        isEmbedded = false;
    }
    
    inline System::String^  BcdElement::ConstructPath() {
        System::String^  strPath = L"root\\WMI:BcdElement";
        return strPath;
    }
    
    inline System::Void BcdElement::InitializeObject(System::Management::ManagementScope^  mgmtScope, System::Management::ManagementPath^  path, 
                System::Management::ObjectGetOptions^  getOptions) {
        Initialize();
        if (path != nullptr) {
            if (CheckIfProperClass(mgmtScope, path, getOptions) != true) {
                throw (gcnew System::ArgumentException(L"Class name does not match."));
            }
        }
        PrivateLateBoundObject = (gcnew System::Management::ManagementObject(mgmtScope, path, getOptions));
        PrivateSystemProperties = (gcnew ROOT::WMI::BcdElement::ManagementSystemProperties(PrivateLateBoundObject));
        curObj = PrivateLateBoundObject;
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances() {
        return GetInstances(nullptr, nullptr, nullptr);
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances(System::String^  condition) {
        return GetInstances(nullptr, condition, nullptr);
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances(cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(nullptr, nullptr, selectedProperties);
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances(System::String^  condition, cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(nullptr, condition, selectedProperties);
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::Management::EnumerationOptions^  enumOptions) {
        if (mgmtScope == nullptr) {
            if (statMgmtScope == nullptr) {
                mgmtScope = (gcnew System::Management::ManagementScope());
                mgmtScope->Path->NamespacePath = L"root\\WMI";
            }
            else {
                mgmtScope = statMgmtScope;
            }
        }
        System::Management::ManagementPath^  pathObj = (gcnew System::Management::ManagementPath());
        pathObj->ClassName = L"BcdElement";
        pathObj->NamespacePath = L"root\\WMI";
        System::Management::ManagementClass^  clsObject = (gcnew System::Management::ManagementClass(mgmtScope, pathObj, nullptr));
        if (enumOptions == nullptr) {
            enumOptions = (gcnew System::Management::EnumerationOptions());
            enumOptions->EnsureLocatable = true;
        }
        return (gcnew ROOT::WMI::BcdElement::BcdElementCollection(clsObject->GetInstances(enumOptions)));
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::String^  condition) {
        return GetInstances(mgmtScope, condition, nullptr);
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                cli::array< System::String ^  >^  selectedProperties) {
        return GetInstances(mgmtScope, nullptr, selectedProperties);
    }
    
    inline ROOT::WMI::BcdElement::BcdElementCollection^  BcdElement::GetInstances(System::Management::ManagementScope^  mgmtScope, 
                System::String^  condition, cli::array< System::String ^  >^  selectedProperties) {
        if (mgmtScope == nullptr) {
            if (statMgmtScope == nullptr) {
                mgmtScope = (gcnew System::Management::ManagementScope());
                mgmtScope->Path->NamespacePath = L"root\\WMI";
            }
            else {
                mgmtScope = statMgmtScope;
            }
        }
        System::Management::ManagementObjectSearcher^  ObjectSearcher = (gcnew System::Management::ManagementObjectSearcher(mgmtScope, 
            (gcnew SelectQuery(L"BcdElement", condition, selectedProperties))));
        System::Management::EnumerationOptions^  enumOptions = (gcnew System::Management::EnumerationOptions());
        enumOptions->EnsureLocatable = true;
        ObjectSearcher->Options = enumOptions;
        return (gcnew ROOT::WMI::BcdElement::BcdElementCollection(ObjectSearcher->Get()));
    }
    
    inline ROOT::WMI::BcdElement^  BcdElement::CreateInstance() {
        System::Management::ManagementScope^  mgmtScope = nullptr;
        if (statMgmtScope == nullptr) {
            mgmtScope = (gcnew System::Management::ManagementScope());
            mgmtScope->Path->NamespacePath = CreatedWmiNamespace;
        }
        else {
            mgmtScope = statMgmtScope;
        }
        System::Management::ManagementPath^  mgmtPath = (gcnew System::Management::ManagementPath(CreatedClassName));
        System::Management::ManagementClass^  tmpMgmtClass = (gcnew System::Management::ManagementClass(mgmtScope, mgmtPath, nullptr));
        return (gcnew ROOT::WMI::BcdElement(tmpMgmtClass->CreateInstance()));
    }
    
    inline System::Void BcdElement::Delete() {
        PrivateLateBoundObject->Delete();
    }
    
    
    inline BcdElement::BcdElementCollection::BcdElementCollection(ManagementObjectCollection^  objCollection) {
        privColObj = objCollection;
    }
    
    inline System::Int32 BcdElement::BcdElementCollection::Count::get() {
        return privColObj->Count;
    }
    
    inline System::Boolean BcdElement::BcdElementCollection::IsSynchronized::get() {
        return privColObj->IsSynchronized;
    }
    
    inline System::Object^  BcdElement::BcdElementCollection::SyncRoot::get() {
        return this;
    }
    
    inline System::Void BcdElement::BcdElementCollection::CopyTo(System::Array^  array, System::Int32 index) {
        privColObj->CopyTo(array, index);
        System::Int32 nCtr;
        for (        nCtr = 0; (nCtr < array->Length);         nCtr = (nCtr + 1)) {
            array->SetValue((gcnew ROOT::WMI::BcdElement((cli::safe_cast<System::Management::ManagementObject^  >(array->GetValue(nCtr))))), 
                nCtr);
        }
    }
    
    inline System::Collections::IEnumerator^  BcdElement::BcdElementCollection::GetEnumerator() {
        return (gcnew ROOT::WMI::BcdElement::BcdElementCollection::BcdElementEnumerator(privColObj->GetEnumerator()));
    }
    
    
    inline BcdElement::BcdElementCollection::BcdElementEnumerator::BcdElementEnumerator(ManagementObjectCollection::ManagementObjectEnumerator^  objEnum) {
        privObjEnum = objEnum;
    }
    
    inline System::Object^  BcdElement::BcdElementCollection::BcdElementEnumerator::Current::get() {
        return (gcnew ROOT::WMI::BcdElement((cli::safe_cast<System::Management::ManagementObject^  >(privObjEnum->Current))));
    }
    
    inline System::Boolean BcdElement::BcdElementCollection::BcdElementEnumerator::MoveNext() {
        return privObjEnum->MoveNext();
    }
    
    inline System::Void BcdElement::BcdElementCollection::BcdElementEnumerator::Reset() {
        privObjEnum->Reset();
    }
    
    
    inline BcdElement::WMIValueTypeConverter::WMIValueTypeConverter(System::Type^  inBaseType) {
        baseConverter = System::ComponentModel::TypeDescriptor::GetConverter(inBaseType);
        baseType = inBaseType;
    }
    
    inline System::Boolean BcdElement::WMIValueTypeConverter::CanConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Type^  srcType) {
        return baseConverter->CanConvertFrom(context, srcType);
    }
    
    inline System::Boolean BcdElement::WMIValueTypeConverter::CanConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Type^  destinationType) {
        return baseConverter->CanConvertTo(context, destinationType);
    }
    
    inline System::Object^  BcdElement::WMIValueTypeConverter::ConvertFrom(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Globalization::CultureInfo^  culture, System::Object^  __identifier(value)) {
        return baseConverter->ConvertFrom(context, culture, __identifier(value));
    }
    
    inline System::Object^  BcdElement::WMIValueTypeConverter::CreateInstance(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Collections::IDictionary^  dictionary) {
        return baseConverter->CreateInstance(context, dictionary);
    }
    
    inline System::Boolean BcdElement::WMIValueTypeConverter::GetCreateInstanceSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetCreateInstanceSupported(context);
    }
    
    inline System::ComponentModel::PropertyDescriptorCollection^  BcdElement::WMIValueTypeConverter::GetProperties(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Object^  __identifier(value), cli::array< System::Attribute^  >^  attributeVar) {
        return baseConverter->GetProperties(context, __identifier(value), attributeVar);
    }
    
    inline System::Boolean BcdElement::WMIValueTypeConverter::GetPropertiesSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetPropertiesSupported(context);
    }
    
    inline System::ComponentModel::TypeConverter::StandardValuesCollection^  BcdElement::WMIValueTypeConverter::GetStandardValues(
                System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValues(context);
    }
    
    inline System::Boolean BcdElement::WMIValueTypeConverter::GetStandardValuesExclusive(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValuesExclusive(context);
    }
    
    inline System::Boolean BcdElement::WMIValueTypeConverter::GetStandardValuesSupported(System::ComponentModel::ITypeDescriptorContext^  context) {
        return baseConverter->GetStandardValuesSupported(context);
    }
    
    inline System::Object^  BcdElement::WMIValueTypeConverter::ConvertTo(System::ComponentModel::ITypeDescriptorContext^  context, 
                System::Globalization::CultureInfo^  culture, System::Object^  __identifier(value), System::Type^  destinationType) {
        if (baseType->BaseType == System::Enum::typeid) {
            if (__identifier(value)->GetType() == destinationType) {
                return __identifier(value);
            }
            if (((__identifier(value) == nullptr) 
                        && (context != nullptr)) 
                        && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
                return  "NULL_ENUM_VALUE" ;
            }
            return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
        }
        if ((baseType == System::Boolean::typeid) 
                    && (baseType->BaseType == System::ValueType::typeid)) {
            if (((__identifier(value) == nullptr) 
                        && (context != nullptr)) 
                        && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
                return L"";
            }
            return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
        }
        if ((context != nullptr) 
                    && (context->PropertyDescriptor->ShouldSerializeValue(context->Instance) == false)) {
            return L"";
        }
        return baseConverter->ConvertTo(context, culture, __identifier(value), destinationType);
    }
    
    
    inline BcdElement::ManagementSystemProperties::ManagementSystemProperties(System::Management::ManagementBaseObject^  ManagedObject) {
        PrivateLateBoundObject = ManagedObject;
    }
    
    inline System::Int32 BcdElement::ManagementSystemProperties::GENUS::get() {
        return (cli::safe_cast<System::Int32 >(PrivateLateBoundObject[L"__GENUS"]));
    }
    
    inline System::String^  BcdElement::ManagementSystemProperties::CLASS::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__CLASS"]));
    }
    
    inline System::String^  BcdElement::ManagementSystemProperties::SUPERCLASS::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__SUPERCLASS"]));
    }
    
    inline System::String^  BcdElement::ManagementSystemProperties::DYNASTY::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__DYNASTY"]));
    }
    
    inline System::String^  BcdElement::ManagementSystemProperties::RELPATH::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__RELPATH"]));
    }
    
    inline System::Int32 BcdElement::ManagementSystemProperties::PROPERTY_COUNT::get() {
        return (cli::safe_cast<System::Int32 >(PrivateLateBoundObject[L"__PROPERTY_COUNT"]));
    }
    
    inline cli::array< System::String^  >^  BcdElement::ManagementSystemProperties::DERIVATION::get() {
        return (cli::safe_cast<cli::array< System::String^  >^  >(PrivateLateBoundObject[L"__DERIVATION"]));
    }
    
    inline System::String^  BcdElement::ManagementSystemProperties::SERVER::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__SERVER"]));
    }
    
    inline System::String^  BcdElement::ManagementSystemProperties::NAMESPACE::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__NAMESPACE"]));
    }
    
    inline System::String^  BcdElement::ManagementSystemProperties::PATH::get() {
        return (cli::safe_cast<System::String^  >(PrivateLateBoundObject[L"__PATH"]));
    }
    }
}
